
/*  
PGSL.h - header file of PGSL, version 2.0 Beta

Copyright (C) Benny Raphael  

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or  any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


*/


#ifndef __OPTIMISER_H___
#define __OPTIMISER_H___

/*  Added 11-10-19999 */
#define NUM_STATIC_INTERVALS 8

struct PAxis {
   int type;
   double min, max;
   int numIntervals;
   double *intervals;  /*  start of each interval  */
   double *prob; /*  Probability of each interval  */
   double *cdf;

   /*  Added 13/10/99 */
   double axisPrecision;   
};

/* 
struct PGSLRecursion {
    int level;   The level of recursion  
    
};
*/

struct ProblemSetup {

   int NS;	/* Iterations in the sampling cycle */
   int NPUC;	/* Iterations in the probability updating cycle */
   int NFC;	/*  Focusing cycle  */
   long NSDC;	/*  subdomain cylcle  */
   int randomSeed;
   int suppressOutput;
   long maxEvaluations;  /*  Maximum number of evaluations  */
   long numEvaluations;   /*  The number of evaluations so far  */

    /*  The user defined cost function pointer  */
   double (*costFunction)(struct ProblemSetup *setup, double *point);

   int numVars;
   struct PAxis ** axes;
   int foundmin;
   double globalMinimum;
   double *minimumPoint;  /* of dimension numVars */
   double threshold;  /*  The minimum cost at which iterations stop  */

   double scaleFactor;
   
   /*  Added Mon Dec  4 18:41:40 PST 2000 */
   int numBiasedSamples;
   int iSDC;  /*  The current iteration in the subdomain cycle  */
   int iFC;  /*  The current iteration in the focusing cycle  */
   int iPUC;  /*  The current iteration in the PU cycle  */
   int iS;  /*  The current iteration in the sampling cycle  */
   double *SDCpoints;  /*  The points in each iter. in the SDC.  of dim numVars*5 */
   double *SDCcosts;   /*  costs in each iter. in the SDC.  of dim 5 */
   void *userData;     /* Any user specific data */
   
    /* Added Sept 2001 */
    int restart;  /*  For adaptive PGSL  */
    int adaptive;  /*  If nsdc is to be adapted  */
	double backupGlobalMinimum;
	double *backupMinimumPoint;

};

int copyPoint(int n, const double *x, double *copy);

/*  Function to create an axis representing a parameter.  */
struct PAxis *PAxis_create(double min, double max);

/*  Function to create the structure representing a problem definition  */
struct ProblemSetup *ProblemSetup_create(int num, int NFC,  long NSDC, double threshold ) ;

int ProblemSetup_delete(struct ProblemSetup *thisp);


/*  Frees memory after checking the validity of object.  If the type is 
   less than 0 it does not delete  */
int PAxis_delete(struct PAxis *thisp);

/* Returns a random number between 0 and 1 */
double randomNumber();

int doSubdomainCycle(struct ProblemSetup *setup, double *min, double *max);
double findMinimum(struct ProblemSetup *setup);

void memory_error();
void fatal_error(char * message);


#endif
