
#include <stdio.h>
#include <math.h>
#include "..\PGSL.h"

/** <A HREF=F8.c> Code </A> <P>
  * Griewank's function F8
  * @version        0.0 Thu Oct 14 15:08:05 PDT 1999 
  * @author         Benny Raphael 

*/



#define NUMRUNS 30

#define numVariables 10
struct ProblemSetup *setup;

static long numTrials = 0;
double bestcost;


double F8_ObjectiveFunction(struct ProblemSetup *setup, double *paramValues){
   double costerm, total, x1;
   int i;

   total = 1;
   for (i=0; i<numVariables; i++) {
      x1 = paramValues[i];
      total += x1*x1/4000.;
   }

   costerm = 1;
   for (i=0; i<numVariables; i++) {
      x1 = paramValues[i];
      costerm *= cos(x1/sqrt(i+1));
   }

   total -= costerm;

   numTrials++;
   if (total < bestcost) bestcost = total;

   if (numTrials % 10000 == 0) {
		printf("\t%ld \t %ld \t %lg\n", numTrials, setup->iSDC, bestcost);
   }
   return total;
}


struct ProblemSetup *setupF8() {
   struct ProblemSetup *ret;
   int j;
   long nfc = 20*numVariables;
   int nsdc = 40;
   double maxtrials = 500000.;

   if (numVariables > 50) maxtrials *= numVariables/50;

   nsdc= (int)(maxtrials/2/nfc);


   ret = ProblemSetup_create(numVariables, nfc, nsdc, 1e-5); 
   
   for (j=0; j<numVariables; j++) {
      ret->axes[j] = PAxis_create(-512,511);
	  ret->axes[j]->axisPrecision = 1e-5;
   }

   ret->costFunction = F8_ObjectiveFunction;
   ret->suppressOutput = 2;
   ret->adaptive = 1;


   return ret;
}
/*----------------------------------------------------------------*/

main() {

   int run;
   int seeds[NUMRUNS];
   double min[NUMRUNS];
   long trials[NUMRUNS];
   int numSuccess=0;
   double sumValue=0;
   long sumTrials=0;
   double meanTrials;
   double meanValue;
   FILE *out;
   char filename[256];

   for (run =0; run <NUMRUNS; run++) {
      
      setup = setupF8();
      setup->randomSeed += run;
      printf("----------------------------------------------------------------");
      printf("\nSeed = %d\n", setup->randomSeed);
      seeds[run] = setup->randomSeed;
	  bestcost = 1e100;

      findMinimum(setup);

	  if (setup->globalMinimum < setup->threshold) {
		  sumTrials += numTrials;
		  numSuccess++;
	  }
	  sumValue += setup->globalMinimum;

      printf("%lg \t %ld Trials\n", setup->globalMinimum, numTrials);
      trials[run] = numTrials;
      min[run] = setup->globalMinimum;
      numTrials = 0;

      ProblemSetup_delete(setup);

   }

   if (numSuccess > 0) {
		meanTrials = sumTrials/numSuccess;
   } else {
	   meanTrials = trials[0];
   }
   meanValue = sumValue/NUMRUNS;

   printf("\n\nSummary\n");
   for (run =0; run <NUMRUNS; run++) {
      printf("\t%d\t%ld\t%lg\n", seeds[run], trials[run], min[run]);
   }
   
	sprintf(filename, "F8-%d.out", numVariables);
	out = fopen(filename, "w");
	if (out == NULL) return 1;

	fprintf(out, "F8 - %d variables\n", numVariables);
	fprintf(out, "Seed \t Evaluations \t Minimum found \n");
	for (run =0; run <NUMRUNS; run++) {
      fprintf(out, "\t%d\t%ld\t%lg\n", seeds[run], trials[run], min[run]);
	}
	fprintf(out, "\n");
	fprintf(out, "Mean number of evaluations = %ld\n", (long)meanTrials);
	fprintf(out, "Mean Value of minima = %lg\n", meanValue);
	fprintf(out, "Success rate = %d %% \n", 100*numSuccess/NUMRUNS);

	fclose(out);

	return 0;
}


