
#include <stdio.h>
#include <math.h>
#include "..\PGSL.h"

/** <A HREF=F10.c> Code </A> <P>
  * Test function F10
  * @version        0.0 Thu Oct 14 15:08:05 PDT 1999 
  * @author         Benny Raphael 

*/



#define NUMRUNS 30

#define numVariables 10
struct ProblemSetup *setup;

static long numTrials = 0;
double bestcost;
double precision22BitGrayscale;

double F10(double x1, double x2) {
   double value=0, sx, sn;

   sx = (x1*x1 + x2*x2);
   sn = sin( 50 * pow(sx, 0.1));
   value = pow(sx, 0.25) * ( sn *sn + 1);
  return(value);
}

/*  Rounds off to the nearest value that corresponds to bit22 representation  */
double bit22RoundOff(double x1) {

	long lval;

	lval = (long)(x1/precision22BitGrayscale);
	x1 = lval * precision22BitGrayscale;
	return x1;
}

double EF10_ObjectiveFunction(struct ProblemSetup *setup, double *paramValues){
   double x1, x2, total;
   int i, j;

   total = 0;
   for (i=0; i<numVariables; i++) {
      x1 = paramValues[i];
	  x1 = bit22RoundOff(x1);
      for (j=0; j<numVariables; j++) {
		if (i==j) continue; 
		x2 = paramValues[j];
		x2 = bit22RoundOff(x2);
		total += F10(x1, x2);
      }
   }


	numTrials++; 
	if (total < bestcost) bestcost = total;

	if (numTrials % 10000 == 0) {
		printf("\t%ld\t %ld \t %lg  \t %lg\n", numTrials, setup->iSDC, total, bestcost);
	}
	return total;
}


struct ProblemSetup *setupEF10() {
   struct ProblemSetup *ret;
   int j;
   long nfc = 20*numVariables;
   int nsdc = 40;
   double maxtrials = 500000.;

   precision22BitGrayscale = 1e-5;

   if (numVariables > 50) maxtrials *= numVariables/50;

   nsdc= (int)(maxtrials/2/nfc);


   ret = ProblemSetup_create(numVariables, nfc, nsdc, 1e-5); 
   
   for (j=0; j<numVariables; j++) {
      ret->axes[j] = PAxis_create(-100, 100);
	  ret->axes[j]->axisPrecision = 1e-4;
   }

   ret->costFunction = EF10_ObjectiveFunction;
   ret->suppressOutput = 2;
   ret->adaptive = 1;


   return ret;
}
/*----------------------------------------------------------------*/

main() {

   int run;
   int seeds[NUMRUNS];
   double min[NUMRUNS];
   long trials[NUMRUNS];
   int numSuccess=0;
   double sumValue=0;
   long sumTrials=0;
   double meanTrials;
   double meanValue;
   FILE *out;
   char filename[256];

   for (run =0; run <NUMRUNS; run++) {
      
      setup = setupEF10();
      setup->randomSeed += run;
      printf("----------------------------------------------------------------");
      printf("\nSeed = %d\n", setup->randomSeed);
      seeds[run] = setup->randomSeed;
	  bestcost = 1e100;

      findMinimum(setup);

	  if (setup->globalMinimum < setup->threshold) {
		  sumTrials += numTrials;
		  numSuccess++;
	  }
	  sumValue += setup->globalMinimum;

      printf("%lg \t %ld Trials\n", setup->globalMinimum, numTrials);
      trials[run] = numTrials;
      min[run] = setup->globalMinimum;
      numTrials = 0;
      ProblemSetup_delete(setup);

   }

   printf("\n\nSummary for %d variables\n", numVariables);
   for (run =0; run <NUMRUNS; run++) {
      printf("\t%d\t%ld\t%lg\n", seeds[run], trials[run], min[run]);
   }
   

   if (numSuccess > 0) {
		meanTrials = sumTrials/numSuccess;
   } else {
	   meanTrials = trials[0];
   }
   meanValue = sumValue/NUMRUNS;

   printf("\n\nSummary\n");
   for (run =0; run <NUMRUNS; run++) {
      printf("\t%d\t%ld\t%lg\n", seeds[run], trials[run], min[run]);
   }
   
	sprintf(filename, "F10-%d.out", numVariables);
	out = fopen(filename, "w");
	if (out == NULL) return 1;

	fprintf(out, "F10 - %d variables\n", numVariables);
	fprintf(out, "Seed \t Evaluations \t Minimum found \n");
	for (run =0; run <NUMRUNS; run++) {
      fprintf(out, "\t%d\t%ld\t%lg\n", seeds[run], trials[run], min[run]);
	}
	fprintf(out, "\n");
	fprintf(out, "Mean number of evaluations = %ld\n", (long)meanTrials);
	fprintf(out, "Mean Value of minima = %lg\n", meanValue);
	fprintf(out, "Success rate = %d %% \n", 100*numSuccess/NUMRUNS);

	fclose(out);

	return 0;

}


