
/*  
ConstraintSolver.h - header file of the ConstraintSolver

Copyright (C) Benny Raphael  

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or  any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


*/


#ifndef __CONSTRAINTSOLVER_H___
#define __CONSTRAINTSOLVER_H___

#include "../PGSL.h"

struct ConstraintProblem;

/*  structure representing a constraint of the form C(x) < 0
*/
struct Constraint {

	double penaltyFactor;		/*  Default is 1e6  */

	/*  Returns the LHS of the constraint relationship for the point
		If the value is greater than zero a penalty is added to the objective function
	*/
	double (*evaluationFunction)(struct ConstraintProblem *problem, double *point);
	
};

struct ConstraintProblem {

	char *title;  /*  A title for the problem - used in printouts  */

	char *outputfilename;  /*  The name of the output file which will be overwritten with the results  */

	long maxNumEvaluations;  /*  Maximum number of evaluations of the objective function  */

	/* To keep track of the number of evaluations of the objective function  */
	long numEvaluations;

	int NFC;	/*  Focusing cycle  */
	long NSDC;	/*  subdomain cylcle  */

    /*  The user defined cost function pointer  */
	double (*objectiveFunction)(struct ConstraintProblem *problem, double *point);

	int numVars;
	struct PAxis ** axes;

	int numConstraints;
	struct Constraint **constraints;	/*  Array of dimension numConstraints  */

	double globalMinimum;
	double *minimumPoint;  /* of dimension numVars */
	double threshold;  /*  The minimum cost at which iterations stop  */

	void *userData;     /* Any user specific data */

	/*  The PGSL problem definition  */
	struct ProblemSetup *PGSLSetup;

	double *penalities;
   
};

/*  User has to define the following function.  See UserHook.c for an example  */
struct ConstraintProblem *setupConstraintProblem();

/*  User has to define the following function.  See UserHook.c for an example  */
void doCleanup(struct ConstraintProblem *setup);

struct ConstraintProblem *ConstraintProblem_create(char *title, int numVariables, int numConstraints, long maxNumEvaluations, double threshold);



/*  Frees memory  */
void ConstraintProblem_delete(struct ConstraintProblem *problem);

double findSolution(struct ConstraintProblem *problem);




#endif
